/*
 * Decompiled with CFR 0.152.
 */
package moe.ytonidc.ytongame_hostingmenu.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import moe.ytonidc.ytongame_hostingmenu.Ytongame_hostingmenu;

public class HostingPackage {
    private static final String REMOTE_JSON_URL = "https://cdn.bbsmc.net/ytonidc/hosting_packages.json";
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private final String name;
    private final String processor;
    private final String memory;
    private final int defaultBackupSlots;
    private final int maxBackupSlots;
    private final String storage;
    private final String recommendedPlayers;
    private final int price;
    private final int color;
    private final String tag;
    private static List<HostingPackage> ALL_PACKAGES = new ArrayList<HostingPackage>();
    private static boolean isLoaded = false;

    public HostingPackage(String name, String processor, String memory, int defaultBackupSlots, int maxBackupSlots, String storage, String recommendedPlayers, int price, int color, String tag) {
        this.name = name;
        this.processor = processor;
        this.memory = memory;
        this.defaultBackupSlots = defaultBackupSlots;
        this.maxBackupSlots = maxBackupSlots;
        this.storage = storage;
        this.recommendedPlayers = recommendedPlayers;
        this.price = price;
        this.color = color;
        this.tag = tag;
    }

    public String getName() {
        return this.name;
    }

    public String getProcessor() {
        return this.processor;
    }

    public String getMemory() {
        return this.memory;
    }

    public int getDefaultBackupSlots() {
        return this.defaultBackupSlots;
    }

    public int getMaxBackupSlots() {
        return this.maxBackupSlots;
    }

    public String getStorage() {
        return this.storage;
    }

    public String getRecommendedPlayers() {
        return this.recommendedPlayers;
    }

    public int getPrice() {
        return this.price;
    }

    public int getColor() {
        return this.color;
    }

    public String getTag() {
        return this.tag;
    }

    public static List<HostingPackage> getAllPackages() {
        return ALL_PACKAGES;
    }

    public static boolean isLoaded() {
        return isLoaded;
    }

    public static void loadAsync() {
        CompletableFuture.runAsync(() -> {
            if (HostingPackage.loadFromRemote()) {
                Ytongame_hostingmenu.LOGGER.info("Loaded {} hosting packages from remote", (Object)ALL_PACKAGES.size());
                isLoaded = true;
                return;
            }
            Ytongame_hostingmenu.LOGGER.warn("Failed to load from remote, falling back to local resources");
            HostingPackage.loadFromResources();
            isLoaded = true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadFromRemote() {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(REMOTE_JSON_URL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("User-Agent", "YtonGame-HostingMenu/ytongame_hostingmenu");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                try (InputStream is = connection.getInputStream();){
                    boolean bl = HostingPackage.loadFromStream(is);
                    return bl;
                }
            }
            Ytongame_hostingmenu.LOGGER.warn("Remote JSON returned status code: {}", (Object)responseCode);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            Ytongame_hostingmenu.LOGGER.warn("Failed to load hosting packages from remote: {}", (Object)e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void loadFromResources() {
        try {
            InputStream is = HostingPackage.class.getResourceAsStream("/hosting_packages.json");
            if (is != null) {
                if (HostingPackage.loadFromStream(is)) {
                    Ytongame_hostingmenu.LOGGER.info("Loaded {} hosting packages from resources", (Object)ALL_PACKAGES.size());
                } else {
                    HostingPackage.loadDefaultPackages();
                }
            } else {
                Ytongame_hostingmenu.LOGGER.error("Could not find hosting_packages.json in resources");
                HostingPackage.loadDefaultPackages();
            }
        }
        catch (Exception e) {
            Ytongame_hostingmenu.LOGGER.error("Failed to load hosting packages from resources", (Throwable)e);
            HostingPackage.loadDefaultPackages();
        }
    }

    private static boolean loadFromStream(InputStream is) {
        boolean bl;
        InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
        try {
            JsonObject root = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonArray packagesArray = root.getAsJsonArray("packages");
            ArrayList<HostingPackage> packages = new ArrayList<HostingPackage>();
            for (JsonElement element : packagesArray) {
                JsonObject obj = element.getAsJsonObject();
                String name = obj.get("name").getAsString();
                String processor = obj.get("processor").getAsString();
                String memory = obj.get("memory").getAsString();
                int defaultBackupSlots = obj.get("defaultBackupSlots").getAsInt();
                int maxBackupSlots = obj.get("maxBackupSlots").getAsInt();
                String storage = obj.get("storage").getAsString();
                String recommendedPlayers = obj.get("recommendedPlayers").getAsString();
                int price = obj.get("price").getAsInt();
                String colorStr = obj.get("color").getAsString();
                int color = HostingPackage.parseColor(colorStr);
                String tag = null;
                if (obj.has("tag") && !obj.get("tag").isJsonNull()) {
                    tag = obj.get("tag").getAsString();
                }
                packages.add(new HostingPackage(name, processor, memory, defaultBackupSlots, maxBackupSlots, storage, recommendedPlayers, price, color, tag));
            }
            ALL_PACKAGES = packages;
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Ytongame_hostingmenu.LOGGER.error("Failed to parse hosting packages JSON", (Throwable)e);
                return false;
            }
        }
        reader.close();
        return bl;
    }

    private static int parseColor(String colorStr) {
        try {
            if (colorStr.startsWith("0x") || colorStr.startsWith("0X")) {
                return (int)Long.parseLong(colorStr.substring(2), 16);
            }
            if (colorStr.startsWith("#")) {
                return (int)Long.parseLong("FF" + colorStr.substring(1), 16);
            }
            return Integer.parseInt(colorStr);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static void loadDefaultPackages() {
        ALL_PACKAGES = new ArrayList<HostingPackage>();
        ALL_PACKAGES.add(new HostingPackage("\u5165\u95e8\u578b", "AMD EPYC 7R13 3.6GHz", "8G", 1, 1, "30G", "2-3\u4eba", 58, -7829368, null));
        ALL_PACKAGES.add(new HostingPackage("\u6807\u51c6\u578b", "Intel Core I7-14700K / AMD Ryzen9 9950X", "10G", 1, 2, "30G", "4-6\u4eba", 88, -11184641, "\u70ed\u9500"));
        ALL_PACKAGES.add(new HostingPackage("\u7075\u6d3b\u578b", "Intel Core I7-14700K / AMD Ryzen9 9950X", "12G", 1, 2, "30G", "6-8\u4eba", 108, -11141291, null));
        ALL_PACKAGES.add(new HostingPackage("\u60a6\u4eab\u578b", "Intel Core I7-14700K / AMD Ryzen9 9950X", "18G", 1, 3, "30G", "9-12\u4eba", 168, -5614081, "\u591a\u4eba\u63a8\u8350"));
        ALL_PACKAGES.add(new HostingPackage("\u66dc\u77f3\u578b", "Intel Core I7-14700K / AMD Ryzen9 9950X", "24G", 1, 5, "30G", "12-15\u4eba", 238, -22016, null));
        Ytongame_hostingmenu.LOGGER.info("Loaded default hosting packages");
    }
}

